// Rad_Menu.js || Radnen 2008 //

// As to make the menu moveable, it'll
// need a few extra parameters //

function Menu(x, y, w, h, style)
{
	if (!this instanceof Menu) return new Menu(style);
	
	this.x = x; this.y = y;
	this.w = w; this.h = h;
	this.xv = x; this.yv = y;
	this.newX = x; this.newY = y;
	this.time       = 0;
	this.onEscape   = function(){};
	this.items      = [];
	this.style      = style || new Style();
	this.itemHeight = this.style.font.getHeight();
	this.preRender  = function() {if (IsMapEngineRunning()) RenderMap();};
	this.postRender = function() {};
	this.menuList   = null;
	this.showArrow  = true;
	this.done       = false;
	this.barColor   = CreateColor(0, 0, 0, 0);
	this.onOpen  = function() {};
	this.onClose = function() {};
	this.cancelKey = KEY_ESCAPE;
	this.selectKey = KEY_ENTER;
}

Menu.prototype.addItem = function(name, execute, description)
{
	if (description === undefined) description = "";
	this.items.push({execute: execute, name: name, description: description});
}

Menu.prototype.select = function()
{
	this.onClose();
	this.done = true;
	this.menuList.style.font.setColorMask(this.menuList.style.colorUp);
	this.menuList.style.fontColor = this.menuList.style.colorUp;
	this.items[this.menuList.index].execute();
}

Menu.prototype.execute = function()
{
	this.menuList = new ListBox(this.x, this.y, this.w, this.h, this.style);
	this.menuList.populate(this.items, "name");
	this.menuList.setItemHeight(this.itemHeight);
	var Me = this;
	this.menuList.onClick = function() { Me.select(); Me.done = true; };
	var lastFr = GetFrameRate();
	
	this.onOpen();
	if (IsMapEngineRunning()) SetFrameRate(GetMapEngineFrameRate());

	while(!this.done)
	{
		this.preRender();
		this.menuList.blit();
		this.postRender();
		FlipScreen();
		if (KeyPress(KEY_UP)) this.menuList.decrement();
		if (KeyPress(KEY_DOWN)) this.menuList.increment();
		if (KeyPress(this.cancelKey)) this.done = true, this.onClose(), this.onEscape();
		if (KeyPress(this.selectKey)) this.select();
	}
	SetFrameRate(lastFr);
}

function ClearKeyQueue()
{
	while (AreKeysLeft()) GetKey();
}